<?php $page_title = "Contact Us"; ?>
<?php include 'includes/header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>Contact Us</h1>
            <p>Get in touch with our data recovery experts</p>
        </div>
    </section>

    <!-- Contact Section -->
	<section class="contact-section" style="padding: 60px 0px 60px 0px;">
	
	
	
        <div class="container">
            <div class="contact-grid">
                <!-- Contact Form -->
                <div class="contact-form-container">
                    <h2>Send Us a Message</h2>
                    <p>Fill out the form below and we'll get back to you as soon as possible.</p>

                    <form class="contact-form" method="POST" action="process_contact.php">
                        <div class="form-group">
                            <label for="name">Full Name *</label>
                            <input type="text" id="name" name="name" required>
                        </div>

                        <div class="form-group">
                            <label for="email">Email Address *</label>
                            <input type="email" id="email" name="email" required>
                        </div>

                        <div class="form-group">
                            <label for="phone">Phone Number *</label>
                            <input type="tel" id="phone" name="phone" required>
                        </div>

                        <div class="form-group">
                            <label for="device-type">Device Type</label>
                            <select id="device-type" name="device_type">
                                <option value="">Select Device Type</option>
                                <option value="hard-disk">Hard Disk Drive</option>
                                <option value="laptop">Laptop</option>
                                <option value="ssd">SSD / NVMe</option>
                                <option value="memory-card">Memory Card / USB</option>
                                <option value="raid">RAID / Server</option>
                                <option value="other">Other</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="message">Describe Your Issue *</label>
                            <textarea id="message" name="message" rows="5" required></textarea>
                        </div>

                        <button type="submit" class="submit-btn">Send Message</button>
                    </form>
                </div>

                <!-- Contact Information -->
                <div class="contact-info-container">
                    <h2>Contact Information</h2>

                    <div class="contact-info-card">
                        <div class="info-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="info-content">
                            <h3>Phone</h3>
                            <p><a href="tel:9640524040">+91 9640524040</a></p>
                        </div>
                    </div>

                    <div class="contact-info-card">
                        <div class="info-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="info-content">
                            <h3>Email</h3>
                            <p><a href="mailto:info@nitishadata.com">info@nitishadata.com</a></p>
                        </div>
                    </div>

                    <div class="contact-info-card">
                        <div class="info-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="info-content">
                            <h3>Address</h3>
                            <p>No 181, 1st Floor, C Block Building<br>
                            Near Pal Lane, Paradise<br>
                            Panjagutta, Secunderabad<br>
                            Telangana, India</p>
                        </div>
                    </div>

                    <div class="contact-info-card">
                        <div class="info-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="info-content">
                            <h3>Business Hours</h3>
                            <p><strong>Monday - Saturday:</strong><br>
                            10:30 AM - 7:00 PM<br><br>
                            <strong>Sunday:</strong> Closed<br><br>
                            <strong>Emergency:</strong> 24/7</p>
                        </div>
                    </div>

                    <div class="social-media-section">
                        <h3>Follow Us</h3>
                        <div class="social-links-large">
                            <a href="#" target="_blank"><i class="fab fa-facebook-f"></i></a>
                            <a href="#" target="_blank"><i class="fab fa-twitter"></i></a>
                            <a href="#" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                            <a href="#" target="_blank"><i class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="map-section">
        <div class="container">
            <h2>Find Us on Map</h2>
            <div class="map-container">
<iframe 
    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3806.397876036326!2d78.48705997583525!3d17.440660601266927!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bcb9a1024f22443%3A0xe7ab4efd104aea76!2sChenoy%20Trade%20Center!5e0!3m2!1sen!2sin!4v1760718601095!5m2!1sen!2sin" 
    width="100%" 
    height="450" 
    style="border:0;" 
    allowfullscreen="" 
    loading="lazy">
</iframe>
            </div>
        </div>
    </section>

    <!-- Emergency Contact Banner -->
    <section class="emergency-contact">
        <div class="container">
            <div class="emergency-content">
                <div class="emergency-icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="emergency-text">
                    <h3>Need Emergency Data Recovery?</h3>
                    <p>We're available 24/7 for critical data recovery situations</p>
                </div>
                <a href="tel:9640524040" class="emergency-btn">Call Now: 9640524040</a>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>