# Nitisha Data Recovery Website - Deployment Guide

## Quick Start Guide

This guide will help you deploy the Nitisha Data Recovery website to your web server.

## Pre-Deployment Checklist

- [ ] Web hosting with PHP support (PHP 7.0+)
- [ ] Domain name configured
- [ ] FTP/File Manager access to server
- [ ] Email account for contact form
- [ ] SSL certificate (recommended)

## Step-by-Step Deployment

### Step 1: Upload Files

**Using FTP Client (FileZilla, WinSCP, etc.):**
1. Connect to your web server using FTP credentials
2. Navigate to your public_html or www folder
3. Upload all files maintaining the folder structure:
   - All PHP files in root
   - includes/ folder with header.php and footer.php
   - css/ folder with style.css
   - js/ folder with script.js
   - images/ folder with all images

**Using cPanel File Manager:**
1. Login to cPanel
2. Open File Manager
3. Navigate to public_html
4. Upload the entire nitisha-data-recovery folder
5. Extract if uploaded as ZIP
6. Move contents from nitisha-data-recovery to public_html

### Step 2: Configure Contact Form

1. Open `process_contact.php` in a text editor
2. Update line 18 with your email address:
   ```php
   $to = "your-email@nitishadata.com";
   ```
3. Save and re-upload if needed

### Step 3: Update Social Media Links

**In header.php (line 23-26):**
```php
<a href="https://facebook.com/your-page" target="_blank"><i class="fab fa-facebook-f"></i></a>
<a href="https://twitter.com/your-profile" target="_blank"><i class="fab fa-twitter"></i></a>
<a href="https://linkedin.com/company/your-company" target="_blank"><i class="fab fa-linkedin-in"></i></a>
<a href="https://instagram.com/your-profile" target="_blank"><i class="fab fa-instagram"></i></a>
```

**Repeat for footer.php (similar section)**

### Step 4: Configure Google Maps

1. Get your business location coordinates
2. Open `contact.php`
3. Update the Google Maps embed URL (around line 85)
4. Or use this tool: https://www.embedgooglemap.net/

### Step 5: Add More Images (Optional)

1. Download professional images from Unsplash.com
2. Recommended searches:
   - "data recovery lab"
   - "server room technology"
   - "hard drive repair"
   - "clean room facility"
3. Place images in the images/ folder
4. Update image references in PHP files if needed

### Step 6: Set File Permissions

**Recommended permissions:**
- Folders: 755
- PHP files: 644
- .htaccess: 644
- images folder: 755

**Using FTP:**
Right-click on files/folders → File Permissions → Set as above

**Using cPanel:**
File Manager → Select files → Permissions → Change

### Step 7: Test the Website

1. **Homepage**: Visit yourdomain.com
2. **Navigation**: Test all menu links
3. **Contact Form**: Submit a test message
4. **Responsive**: Check on mobile devices
5. **Email**: Verify contact form email delivery

## Common Issues & Solutions

### Issue 1: Contact Form Not Sending Emails

**Solutions:**
- Check PHP mail() function is enabled on server
- Use SMTP plugin or PHPMailer for better delivery
- Check spam folder for test emails
- Verify email address in process_contact.php

### Issue 2: Images Not Loading

**Solutions:**
- Check file paths are correct
- Verify images are uploaded to images/ folder
- Check file permissions (755 for folder, 644 for images)
- Clear browser cache

### Issue 3: .htaccess Errors

**Solutions:**
- Ensure mod_rewrite is enabled on Apache
- Remove .htaccess if causing 500 errors
- Contact hosting provider for Apache configuration

### Issue 4: CSS/JS Not Loading

**Solutions:**
- Check file paths in header.php
- Verify files are in correct folders
- Clear browser cache (Ctrl+F5)
- Check file permissions

## SEO Optimization

### 1. Submit to Google Search Console
- Visit: https://search.google.com/search-console
- Add your property (domain)
- Submit sitemap (create sitemap.xml)

### 2. Submit to Google My Business
- Claim your business listing
- Add photos and business hours
- Get reviews from customers

### 3. Local SEO
- Register on Justdial, Sulekha, IndiaMART
- Add business to local directories
- Optimize for "data recovery Hyderabad" keywords

## Security Checklist

- [ ] Install SSL certificate (HTTPS)
- [ ] Keep PHP updated
- [ ] Use strong passwords
- [ ] Regular backups
- [ ] Install security plugins (if using cPanel)
- [ ] Monitor for malware
- [ ] Keep contact form secure

## Performance Optimization

1. **Enable Compression**: Already in .htaccess
2. **Image Optimization**: Use TinyPNG.com before uploading
3. **Browser Caching**: Already in .htaccess
4. **Minify CSS/JS**: Use online minifiers if needed
5. **Use CDN**: Consider Cloudflare for faster loading

## Backup Procedure

**Automated Backup (Recommended):**
- Enable daily backups in cPanel
- Download weekly backups to local storage

**Manual Backup:**
1. Download all files via FTP
2. Export database (if you add one later)
3. Store in secure location

## Maintenance Tasks

**Weekly:**
- Check contact form submissions
- Monitor website uptime
- Review error logs

**Monthly:**
- Update content if needed
- Check for broken links
- Review analytics
- Backup website

**Quarterly:**
- Update PHP version if needed
- Review and update SEO
- Add new content/images
- Check competitor websites

## Email Configuration for Contact Form

### Using PHPMailer (Recommended for Better Delivery)

1. Download PHPMailer from: https://github.com/PHPMailer/PHPMailer
2. Upload to includes/ folder
3. Update process_contact.php to use PHPMailer:

```php
require 'includes/PHPMailer/PHPMailer.php';
require 'includes/PHPMailer/SMTP.php';

$mail = new PHPMailer();
$mail->isSMTP();
$mail->Host = 'smtp.gmail.com';
$mail->SMTPAuth = true;
$mail->Username = 'your-email@gmail.com';
$mail->Password = 'your-app-password';
$mail->SMTPSecure = 'tls';
$mail->Port = 587;
```

## Support & Help

For any deployment issues or customization:
- Contact: Hyderabad Graphics
- Phone: 9849851841
- Email: info@hyderabadgraphics.com

## Post-Deployment Checklist

- [ ] All pages load correctly
- [ ] Contact form works
- [ ] Mobile responsive
- [ ] Images display properly
- [ ] Social links work
- [ ] Google Maps shows correctly
- [ ] SSL certificate active
- [ ] Submitted to Google Search Console
- [ ] Analytics installed (Google Analytics)
- [ ] Backup configured

## Additional Features (Future Enhancements)

1. **Blog Section**: Add articles about data recovery
2. **Customer Reviews**: Testimonials section
3. **Live Chat**: Add chat support
4. **Online Booking**: Schedule appointments
5. **FAQ Page**: Common questions
6. **Case Studies**: Success stories
7. **Multiple Languages**: Telugu translation

## Conclusion

Your website is now ready to go live! Follow these steps carefully and your Nitisha Data Recovery website will be up and running smoothly.

For ongoing support and updates, keep in touch with Hyderabad Graphics.

---

**Deployed by**: Hyderabad Graphics
**Date**: October 2025
**Version**: 1.0
