<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Comprehensive data recovery services - Hard disk, laptop, CCTV, mobile, RAID recovery. Professional data recovery with 98% success rate in Hyderabad.">
    <meta name="keywords" content="data recovery services, hard disk recovery, laptop recovery, CCTV recovery, mobile recovery, RAID recovery, server recovery">
    <title>Data Recovery Services - Nitisha Data Recovery Hyderabad</title>
    <link rel="canonical" href="https://nitishadata.com/services.php">
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>Our Data Recovery Services</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Services</li>
                </ol>
            </nav>
        </div>
    </section>

    <!-- Services Detail -->
    <section class="services-detail">
        <div class="container">
            <!-- Hard Disk Recovery -->
            <div class="service-section">
                <div class="row">
                    <div class="col-md-6">
                        <h2><i class="fas fa-hdd"></i> Hard Disk Data Recovery</h2>
                        <p class="lead">Professional recovery from all types of hard drives with advanced techniques and equipment.</p>

                        <h3>We Recover From:</h3>
                        <ul>
                            <li>Desktop Hard Drives (IDE, SATA, SCSI, SAS)</li>
                            <li>Laptop Hard Drives (2.5" and 1.8")</li>
                            <li>External Hard Drives (USB, FireWire, Thunderbolt)</li>
                            <li>Solid State Drives (SSD)</li>
                            <li>NVMe M.2 Drives</li>
                        </ul>

                        <h3>Supported Brands:</h3>
                        <div class="brands">
                            <span class="brand">Seagate</span>
                            <span class="brand">Western Digital</span>
                            <span class="brand">Samsung</span>
                            <span class="brand">Maxtor</span>
                            <span class="brand">Toshiba</span>
                            <span class="brand">Hitachi</span>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <img src="images/hard-disk-recovery.jpg" alt="Hard Disk Data Recovery" class="img-fluid rounded">

                        <div class="service-features">
                            <h3>Common Issues We Fix:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Hard disk not detected</li>
                                <li><i class="fas fa-check"></i> Clicking/grinding sounds</li>
                                <li><i class="fas fa-check"></i> Boot failure</li>
                                <li><i class="fas fa-check"></i> Corrupted file system</li>
                                <li><i class="fas fa-check"></i> Accidental formatting</li>
                                <li><i class="fas fa-check"></i> Bad sectors</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- CCTV Recovery -->
            <div class="service-section">
                <div class="row">
                    <div class="col-md-6">
                        <img src="images/cctv-recovery.jpg" alt="CCTV Data Recovery" class="img-fluid rounded">
                    </div>

                    <div class="col-md-6">
                        <h2><i class="fas fa-video"></i> CCTV Data Recovery</h2>
                        <p class="lead">Specialized recovery of surveillance footage from CCTV systems, DVRs, and security cameras.</p>

                        <h3>CCTV Systems We Support:</h3>
                        <ul>
                            <li>Digital Video Recorders (DVR)</li>
                            <li>Network Video Recorders (NVR)</li>
                            <li>IP Cameras</li>
                            <li>Analog CCTV Systems</li>
                            <li>Sony Handycam</li>
                            <li>Security Camera Storage</li>
                        </ul>

                        <h3>Recovery Scenarios:</h3>
                        <ul>
                            <li><i class="fas fa-check"></i> Deleted footage recovery</li>
                            <li><i class="fas fa-check"></i> Corrupted video files</li>
                            <li><i class="fas fa-check"></i> System crash recovery</li>
                            <li><i class="fas fa-check"></i> Format recovery</li>
                            <li><i class="fas fa-check"></i> Power failure damage</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Mobile & Memory Card Recovery -->
            <div class="service-section">
                <div class="row">
                    <div class="col-md-6">
                        <h2><i class="fas fa-mobile-alt"></i> Mobile & Memory Card Recovery</h2>
                        <p class="lead">Recovery from smartphones, tablets, and all types of memory cards and portable storage devices.</p>

                        <h3>Devices We Support:</h3>
                        <ul>
                            <li>Android Smartphones & Tablets</li>
                            <li>iOS Devices (iPhone, iPad)</li>
                            <li>SD Cards (all sizes)</li>
                            <li>MicroSD Cards</li>
                            <li>CF Cards</li>
                            <li>USB Flash Drives</li>
                            <li>Memory Sticks</li>
                        </ul>

                        <h3>Common Problems:</h3>
                        <ul>
                            <li><i class="fas fa-check"></i> Accidental deletion</li>
                            <li><i class="fas fa-check"></i> Water damage</li>
                            <li><i class="fas fa-check"></i> Physical damage</li>
                            <li><i class="fas fa-check"></i> Virus infection</li>
                            <li><i class="fas fa-check"></i> Card not recognized</li>
                        </ul>
                    </div>

                    <div class="col-md-6">
                        <img src="images/mobile-recovery.jpg" alt="Mobile Data Recovery" class="img-fluid rounded">
                    </div>
                </div>
            </div>

            <!-- RAID Recovery -->
            <div class="service-section">
                <div class="row">
                    <div class="col-md-6">
                        <img src="images/raid-recovery.jpg" alt="RAID Data Recovery" class="img-fluid rounded">
                    </div>

                    <div class="col-md-6">
                        <h2><i class="fas fa-server"></i> RAID & Server Recovery</h2>
                        <p class="lead">Complex RAID array and server data recovery with specialized expertise and equipment.</p>

                        <h3>RAID Configurations:</h3>
                        <ul>
                            <li>RAID 0 (Striping)</li>
                            <li>RAID 1 (Mirroring)</li>
                            <li>RAID 5 (Striping with Parity)</li>
                            <li>RAID 6 (Double Parity)</li>
                            <li>RAID 10 (Mirrored Stripes)</li>
                            <li>Custom RAID Configurations</li>
                        </ul>

                        <h3>Server Types:</h3>
                        <ul>
                            <li><i class="fas fa-check"></i> Windows Servers</li>
                            <li><i class="fas fa-check"></i> Linux Servers</li>
                            <li><i class="fas fa-check"></i> NAS Systems</li>
                            <li><i class="fas fa-check"></i> SAN Storage</li>
                            <li><i class="fas fa-check"></i> Virtual Machines</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Operating Systems -->
    <section class="os-support">
        <div class="container">
            <h2>Supported Operating Systems</h2>
            <div class="os-grid">
                <div class="os-item">
                    <i class="fab fa-windows"></i>
                    <h3>Windows</h3>
                    <p>All versions from Windows XP to Windows 11</p>
                </div>

                <div class="os-item">
                    <i class="fab fa-apple"></i>
                    <h3>macOS</h3>
                    <p>Mac OS X and all macOS versions</p>
                </div>

                <div class="os-item">
                    <i class="fab fa-linux"></i>
                    <h3>Linux</h3>
                    <p>All major Linux distributions</p>
                </div>

                <div class="os-item">
                    <i class="fas fa-server"></i>
                    <h3>Unix</h3>
                    <p>Various Unix variants and systems</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Emergency Service -->
    <section class="emergency-service">
        <div class="container">
            <h2>Emergency Data Recovery Service</h2>
            <p>Critical data loss? Need immediate recovery? Our emergency service is available 24/7 for urgent cases.</p>
            <a href="tel:+919640524040" class="btn-primary">
                <i class="fas fa-phone"></i> Emergency: 9640524040
            </a>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="main.js"></script>
</body>
</html>