<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found | Nitisha Data Recovery</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="error-page">
        <div class="container">
            <div class="error-content">
                <div class="error-code">404</div>
                <h1>Page Not Found</h1>
                <p>The page you're looking for doesn't exist or has been moved.</p>

                <div class="error-actions">
                    <a href="index.php" class="btn-primary">
                        <i class="fas fa-home"></i> Go Home
                    </a>
                    <a href="contact.php" class="btn-secondary">
                        <i class="fas fa-envelope"></i> Contact Us
                    </a>
                </div>

                <div class="search-section">
                    <h3>Looking for our services?</h3>
                    <div class="quick-links">
                        <a href="services.php">Data Recovery Services</a>
                        <a href="contact.php">Contact Information</a>
                        <a href="about.php">About Our Company</a>
                        <a href="tel:+919640524040">Emergency Support</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
    .error-page {
        padding: 5rem 0;
        text-align: center;
        min-height: 60vh;
        display: flex;
        align-items: center;
    }

    .error-code {
        font-size: 8rem;
        font-weight: bold;
        color: var(--primary-color);
        line-height: 1;
        margin-bottom: 1rem;
    }

    .error-content h1 {
        font-size: 2.5rem;
        margin-bottom: 1rem;
    }

    .error-content p {
        font-size: 1.125rem;
        margin-bottom: 2rem;
    }

    .error-actions {
        display: flex;
        gap: 1rem;
        justify-content: center;
        margin-bottom: 3rem;
        flex-wrap: wrap;
    }

    .search-section {
        max-width: 600px;
        margin: 0 auto;
        padding: 2rem;
        background: var(--bg-light);
        border-radius: var(--radius-lg);
    }

    .quick-links {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-top: 1rem;
    }

    .quick-links a {
        background: var(--bg-white);
        padding: 1rem;
        border-radius: var(--radius-md);
        text-decoration: none;
        color: var(--primary-color);
        font-weight: 500;
        transition: var(--transition);
    }

    .quick-links a:hover {
        transform: translateY(-2px);
        box-shadow: var(--shadow-md);
    }
    </style>

    <?php include 'includes/footer.php'; ?>
</body>
</html>