<?php
// Contact form processing
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize input data
    $name = filter_var(trim($_POST['name']), FILTER_SANITIZE_STRING);
    $phone = filter_var(trim($_POST['phone']), FILTER_SANITIZE_STRING);
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $device = filter_var(trim($_POST['device']), FILTER_SANITIZE_STRING);
    $problem = filter_var(trim($_POST['problem']), FILTER_SANITIZE_STRING);
    $urgency = filter_var(trim($_POST['urgency']), FILTER_SANITIZE_STRING);

    // Validation
    $errors = [];

    if (empty($name)) {
        $errors[] = "Name is required";
    }

    if (empty($phone)) {
        $errors[] = "Phone number is required";
    }

    if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format";
    }

    if (empty($device)) {
        $errors[] = "Device type is required";
    }

    if (empty($problem)) {
        $errors[] = "Problem description is required";
    }

    if (empty($errors)) {
        // Save to file (flat file database)
        $data = [
            'timestamp' => date('Y-m-d H:i:s'),
            'name' => $name,
            'phone' => $phone,
            'email' => $email,
            'device' => $device,
            'problem' => $problem,
            'urgency' => $urgency,
            'ip_address' => $_SERVER['REMOTE_ADDR']
        ];

        // Create data directory if it doesn't exist
        if (!is_dir('data')) {
            mkdir('data', 0755, true);
        }

        // Save to JSON file
        $filename = 'data/contacts_' . date('Y-m') . '.json';
        $contacts = [];

        if (file_exists($filename)) {
            $contacts = json_decode(file_get_contents($filename), true) ?: [];
        }

        $contacts[] = $data;
        file_put_contents($filename, json_encode($contacts, JSON_PRETTY_PRINT));

        // Send email notification (if mail server is configured)
        $to = "info@nitishadata.com";
        $subject = "New Data Recovery Inquiry from " . $name;
        $message = "Name: " . $name . "\n";
        $message .= "Phone: " . $phone . "\n";
        $message .= "Email: " . $email . "\n";
        $message .= "Device: " . $device . "\n";
        $message .= "Problem: " . $problem . "\n";
        $message .= "Urgency: " . $urgency . "\n";
        $message .= "Timestamp: " . date('Y-m-d H:i:s') . "\n";

        $headers = "From: noreply@nitishadata.com\r\n";
        $headers .= "Reply-To: " . $email . "\r\n";

        // Uncomment if mail server is configured
        // mail($to, $subject, $message, $headers);

        // Redirect to thank you page
        header("Location: thank-you.php?status=success");
        exit;

    } else {
        // Redirect back with errors
        $error_string = implode(", ", $errors);
        header("Location: contact.php?error=" . urlencode($error_string));
        exit;
    }
} else {
    // If not POST request, redirect to contact page
    header("Location: contact.php");
    exit;
}
?>