<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Contact Nitisha Data Recovery - Get free data recovery consultation. Call 9640524040 or visit our Hyderabad locations for professional data recovery services.">
    <meta name="keywords" content="contact data recovery, data recovery consultation, nitisha data recovery contact, hyderabad data recovery contact">
    <title>Contact Us - Nitisha Data Recovery Hyderabad | 9640524040</title>
    <link rel="canonical" href="https://nitishadata.com/contact.php">
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>Contact Us</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Contact</li>
                </ol>
            </nav>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section">
        <div class="container">
            <div class="row">
                <!-- Contact Form -->
                <div class="col-md-6">
                    <h2>Get Free Data Recovery Consultation</h2>
                    <p>Fill out the form below and our experts will contact you within 24 hours with a free assessment of your data recovery needs.</p>

                    <form class="contact-form" action="process-contact.php" method="POST">
                        <div class="form-group">
                            <label for="name">Full Name *</label>
                            <input type="text" id="name" name="name" required>
                        </div>

                        <div class="form-group">
                            <label for="phone">Phone Number *</label>
                            <input type="tel" id="phone" name="phone" required>
                        </div>

                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input type="email" id="email" name="email">
                        </div>

                        <div class="form-group">
                            <label for="device">Device Type *</label>
                            <select id="device" name="device" required>
                                <option value="">Select Device Type</option>
                                <option value="desktop-hdd">Desktop Hard Drive</option>
                                <option value="laptop-hdd">Laptop Hard Drive</option>
                                <option value="external-hdd">External Hard Drive</option>
                                <option value="ssd">SSD Drive</option>
                                <option value="cctv">CCTV/DVR</option>
                                <option value="mobile">Mobile Phone</option>
                                <option value="memory-card">Memory Card</option>
                                <option value="usb">USB Drive</option>
                                <option value="raid">RAID/Server</option>
                                <option value="other">Other</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="problem">Problem Description *</label>
                            <textarea id="problem" name="problem" rows="4" placeholder="Please describe the issue with your device..." required></textarea>
                        </div>

                        <div class="form-group">
                            <label for="urgency">Urgency Level</label>
                            <select id="urgency" name="urgency">
                                <option value="normal">Normal (2-3 days)</option>
                                <option value="urgent">Urgent (24 hours)</option>
                                <option value="emergency">Emergency (Same day)</option>
                            </select>
                        </div>

                        <div class="form-group checkbox-group">
                            <label>
                                <input type="checkbox" name="agreement" required>
                                I agree to the <a href="privacy-policy.php">Privacy Policy</a> and <a href="terms.php">Terms of Service</a>
                            </label>
                        </div>

                        <button type="submit" class="btn-primary">
                            <i class="fas fa-paper-plane"></i> Send Inquiry
                        </button>
                    </form>
                </div>

                <!-- Contact Information -->
                <div class="col-md-6">
                    <div class="contact-info">
                        <h2>Get in Touch</h2>

                        <div class="contact-item">
                            <i class="fas fa-phone"></i>
                            <div>
                                <h3>Phone</h3>
                                <p><a href="tel:+919640524040">+91 9640524040</a></p>
                                <small>Available 24/7 for emergencies</small>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fab fa-whatsapp"></i>
                            <div>
                                <h3>WhatsApp</h3>
                                <p><a href="https://wa.me/919640524040" target="_blank">+91 9640524040</a></p>
                                <small>Quick response via WhatsApp</small>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <div>
                                <h3>Email</h3>
                                <p><a href="mailto:info@nitishadata.com">info@nitishadata.com</a></p>
                                <small>We'll respond within 2 hours</small>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fas fa-clock"></i>
                            <div>
                                <h3>Working Hours</h3>
                                <p>Monday - Saturday: 9:00 AM - 6:00 PM</p>
                                <small>Emergency services available 24/7</small>
                            </div>
                        </div>
                    </div>

                    <!-- Emergency Contact -->
                    <div class="emergency-contact">
                        <h3><i class="fas fa-exclamation-triangle"></i> Emergency Service</h3>
                        <p>Critical data loss? Need immediate recovery?</p>
                        <a href="tel:+919640524040" class="btn-emergency">
                            <i class="fas fa-phone"></i> Call Now: 9640524040
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Locations -->
    <section class="locations">
        <div class="container">
            <h2>Our Locations</h2>
            <div class="row">
                <div class="col-md-6">
                    <div class="location-card">
                        <h3><i class="fas fa-map-marker-alt"></i> Secunderabad Office</h3>
                        <address>
                            Nitisha Data Recovery Center<br>
                            Sri Venkateswara Apartments<br>
                            Near Kalyani Cinema Hall<br>
                            Sai Krishna Colony, Old Bowenpally<br>
                            Secunderabad - 500011<br>
                            Telangana, India
                        </address>
                        <a href="https://goo.gl/maps/example1" target="_blank" class="location-link">
                            <i class="fas fa-directions"></i> Get Directions
                        </a>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="location-card">
                        <h3><i class="fas fa-map-marker-alt"></i> Hyderabad Office</h3>
                        <address>
                            Nitisha Data Recovery Center<br>
                            Shop No 181, 1st Floor, C Block<br>
                            Cheney Trade Center<br>
                            Near Paradise & Park Line<br>
                            Hyderabad - 500003<br>
                            Telangana, India
                        </address>
                        <a href="https://goo.gl/maps/example2" target="_blank" class="location-link">
                            <i class="fas fa-directions"></i> Get Directions
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq-section">
        <div class="container">
            <h2>Frequently Asked Questions</h2>
            <div class="faq-list">
                <div class="faq-item">
                    <h3>How much does data recovery cost?</h3>
                    <p>Our pricing starts from ₹2,000 for basic logical recovery. The final cost depends on the device type, damage severity, and data size. We provide free evaluation and quote before starting any work.</p>
                </div>

                <div class="faq-item">
                    <h3>How long does data recovery take?</h3>
                    <p>Most logical recoveries are completed within 24-48 hours. Physical damage recovery may take 3-5 days depending on complexity. Emergency services are available for critical cases.</p>
                </div>

                <div class="faq-item">
                    <h3>Is my data secure with you?</h3>
                    <p>Absolutely. We maintain strict confidentiality protocols and are ISO 27001 certified for information security. Your data is handled with utmost privacy and securely destroyed after successful recovery.</p>
                </div>

                <div class="faq-item">
                    <h3>Do you offer "No Recovery, No Fee" guarantee?</h3>
                    <p>Yes, we only charge after successful data recovery. If we cannot recover your data, you don't pay anything except for diagnostic charges in complex cases.</p>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>